<?php
# Helpdesk software Hesk
# Version: 0.93 from July 5, 2005 (patch 0.93.1)
# File name: common.inc.php
# File last modified: Sept 16, 2005
# Written 23rd April 2005 by Klemen Stirn (info@phpjunkyard.com)
# http://www.PHPJunkYard.com

##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 2005 PHPJunkYard All Rights Reserved.                            #
#                                                                            #
# The Hesk may be used and modified free of charge by anyone AS LONG AS      #
# THIS COPYRIGHT NOTICE AND ALL THE COMMENTS REMAIN INTACT. By using this    #
# code you agree to indemnify Klemen Stirn from any liability that might     #
# arise from it's use.                                                       #
#                                                                            #
# Selling the code for this program or any portion of it without prior       #
# written consent is expressly forbidden.                                    #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium. In all cases copyright and header must remain intact. #
# This Copyright is in full effect in any country that has International     #
# Trade Agreements with the United States of America or with                 #
# the European Union.                                                        #
##############################################################################

#############################
#     DO NOT EDIT BELOW     #
#############################

/* Check if this is a valid include */
if (!defined('IN_SCRIPT')) {die($hesklang['attempt']);}


/***************************
Function hesk_formatDate()
***************************/
function hesk_formatDate($dt)
{
    $dt=str_replace(' ','<br>',$dt);
	return($dt);
} // End hesk_formatDate()


/***************************
Function hesk_makeURL()
***************************/
function hesk_makeURL($strUrl)
{
	$myMsg = ' ' . $strUrl;
	$myMsg = preg_replace("#(^|[\n ])([\w]+?://[^ \"\n\r\t<]*)#is", "$1<a href=\"$2\" target=\"_blank\">$2</a>", $myMsg);
	$myMsg = preg_replace("#(^|[\n ])((www|ftp)\.[^ \"\t\n\r<]*)#is", "$1<a href=\"http://$2\" target=\"_blank\">$2</a>", $myMsg);
	$myMsg = preg_replace("#(^|[\n ])([a-z0-9&\-_.]+?)@([\w\-]+\.([\w\-\.]+\.)*[\w]+)#i", "$1<a href=\"mailto:$2@$3\">$2@$3</a>", $myMsg);
	$myMsg = substr($myMsg, 1);
	return($myMsg);
} // End hesk_makeURL()


/***************************
Function hesk_isNumber()
***************************/
function hesk_isNumber($in,$error=0) {

	$in = trim($in);

	if (preg_match("/\D/",$in) || $in=="")
    {
    	if ($error)
        {
        	hesk_error($error);
        }
        else
        {
        	return '';
        }
    }

    return $in;

} // END hesk_isNumber()


/***************************
Function hesk_PasswordSyntax()
***************************/
function hesk_PasswordSyntax($password,$error,$checklength=1) {

	if (preg_match("/\W|\_|\./",$password) || empty($password))
    {
    	hesk_error($error);
    }

    if ($checklength==1 && strlen($password) < 5)
    {
    	hesk_error($error);
    }

    return $password;

} // END hesk_PasswordSyntax()


/***************************
Function hesk_validateURL()
***************************/
function hesk_validateURL($url,$error) {

	$url = trim($url);

	if (preg_match("/^(https?:\/\/+[\w\-]+\.[\w\-]+)/i",$url))
    {
    	return $url;
    }

    hesk_error($error);

} // END hesk_validateURL()


/***************************
Function hesk_input()
***************************/
function hesk_input($in,$error=0) {

	$in = trim($in);

    if (strlen($in))
    {
        $in = htmlspecialchars($in);
    }
    elseif ($error)
    {
    	hesk_error($error);
    }

    if (!ini_get('magic_quotes_gpc'))
    {
        if (!is_array($in))
            $in = addslashes($in);
        else
            $in = hesk_slashArray($in);
    }

    return $in;

} // END hesk_input()


/***************************
Function hesk_validateEmail()
***************************/
function hesk_validateEmail($address,$error) {

	$address = trim($address);

	if (preg_match("/([\w\-]+\@[\w\-]+\.[\w\-]+)/",$address))
    {
    	return $address;
    }

    hesk_error($error);

} // END hesk_validateEmail()


/***************************
Function hesk_myCategories()
***************************/
function hesk_myCategories($what='category') {

    if (!empty($_SESSION['isadmin']))
    {
    	return '1';
    }
    else
    {
    	$mycat_sql='(';
        $i=1;
        foreach ($_SESSION['categories'] as $mycat)
        {
        	if ($i) {
            $mycat_sql.=" `$what`=$mycat ";
            } else {
            $mycat_sql.=" OR `$what`=$mycat ";
            }
        	$i=0;
        }
        $mycat_sql.=')';
        return $mycat_sql;
    }

} // END hesk_myCategories()


/***************************
Function hesk_okCategory()
***************************/
function hesk_okCategory($cat) {

    if (!empty($_SESSION['isadmin']))
    {
    	return true;
    }
    elseif (in_array($cat,$_SESSION['categories']))
    {
    	return true;
    }
    else
    {
        global $hesklang;
        hesk_error($hesklang['not_authorized_tickets']);
    }

} // END hesk_okCategory()


/***************************
Function hesk_isAdmin()
***************************/
function hesk_isAdmin() {

    if (empty($_SESSION['isadmin']))
    {
        global $hesklang;
        hesk_error("$hesklang[must_be_admin]<p>&nbsp;</p>
		<p align=\"center\"><a href=\"admin.php\">$hesklang[click_login]</a>");
    }
    else
    {
        session_regenerate_id();
        return true;
    }

} // END hesk_isAdmin()


/***************************
Function hesk_isLoggedIn()
***************************/
function hesk_isLoggedIn() {

    if (empty($_SESSION['id']))
    {
        $url='admin.php?a=login&notice=1&goto='.urlencode($_SERVER['REQUEST_URI']);
        Header("Location: $url");
        exit();
    }
    else
    {
	    session_regenerate_id();
        return true;
    }

} // END hesk_isLoggedIn()


/***************************
Function hesk_session_start()
***************************/
function hesk_session_start() {

    if (session_start())
    return true;
    else
    global $hesk_settings, $hesklang;
    hesk_error("$hesklang[no_session] $hesklang[contact_webmaster] $hesk_settings[webmaster_mail]");

} // END hesk_session_start()


/***************************
Function hesk_session_stop()
***************************/
function hesk_session_stop() {

    session_unset();
	session_destroy();
    return true;

} // END hesk_session_stop()


/***************************
Function hesk_slashArray()
***************************/
function youraff_slashArray ($a)
{
	while (list($k,$v) = each($a))
	{
		if (!is_array($v))
			$a[$k] = addslashes($v);
		else
			$a[$k] = hesk_slashArray($v);
	}

	reset ($a);
	return ($a);
} // END hesk_slashArray()


/***************************
Function hesk_error()
***************************/
function hesk_error($error) {
global $hesk_settings, $hesklang;

require_once('inc/header.inc.php');
?>

<p class="smaller"><a href="<?php echo $hesk_settings['site_url']; ?>"
class="smaller"><?php echo $hesk_settings['site_title']; ?></a> &gt;
<a href=<?php
if (empty($_SESSION['id'])) {echo "\"index.php?a=start\"";}
else {echo "\"admin_main.php\"";}
?> class="smaller"><?php echo $hesk_settings['hesk_title']; ?></a>
&gt; <?php echo $hesklang['error']; ?><br>&nbsp;</p>
</td>
</tr>
<tr>
<td>

<p>&nbsp;</p>
<h3 align="center"><?php echo $hesklang['error']; ?></h3>
<p>&nbsp;</p>

<p align="center"><?php echo $error; ?></p>
<p>&nbsp;</p>
<p align="center"><a href="javascript:history.go(-1)"><?php echo $hesklang['back']; ?></a></p>

<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>

<?php
require_once('inc/footer.inc.php');
exit();
} // END hesk_error()

?>