<?php
# Helpdesk software Hesk
# Version: 0.93b from July 5, 2005
# File name: find_tickets.php
# File last modified: July 5, 2005
# Written 23rd April 2005 by Klemen Stirn (info@phpjunkyard.com)
# http://www.PHPJunkYard.com

##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 2005 PHPJunkYard All Rights Reserved.                            #
#                                                                            #
# The Hesk may be used and modified free of charge by anyone AS LONG AS      #
# THIS COPYRIGHT NOTICE AND ALL THE COMMENTS REMAIN INTACT. By using this    #
# code you agree to indemnify Klemen Stirn from any liability that might     #
# arise from it's use.                                                       #
#                                                                            #
# Selling the code for this program or any portion of it without prior       #
# written consent is expressly forbidden.                                    #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium. In all cases copyright and header must remain intact. #
# This Copyright is in full effect in any country that has International     #
# Trade Agreements with the United States of America or with                 #
# the European Union.                                                        #
##############################################################################

#############################
#     DO NOT EDIT BELOW     #
#############################

define('IN_SCRIPT',1);

/* Get all the required files and functions */
require_once('hesk_settings.inc.php');
require_once('language/'.$hesk_settings['language'].'.inc.php'); 
require_once('inc/common.inc.php');
hesk_session_start();
hesk_isLoggedIn();
require_once('inc/database.inc.php');
hesk_dbConnect() or hesk_error("$hesklang[cant_connect_db] $hesklang[contact_webmsater] $hesk_settings[webmaster_mail]!");

/* Print header */
require_once('inc/header.inc.php');

$sql = "SELECT * FROM `hesk_tickets` WHERE ";
$sql .= hesk_myCategories();
$sql .= " AND ";

/* Get all the SQL sorting preferences */
$what=hesk_input($_GET['what'],"$hesklang[int_error]: no what defined");

switch ($what) {
case "trackid":
	$extra=hesk_input($_GET['trackid'],$hesklang['enter_id']);
	$sql .= "`trackid` = '$extra' ";
    break;
case "name":
    $extra=hesk_input($_GET['name'],$hesklang['enter_name']);
	$sql .= "`name` LIKE '%$extra%' ";
    break;
case "dt":
	$extra=hesk_input($_GET['dt'],$hesklang['enter_date']);
	    if (!preg_match("/\d{4}-\d{2}-\d{2}/",$extra))
	    {
	        hesk_error($hesklang['date_not_valid']);
	    }
	$sql .= "`dt` LIKE '$extra%' ";
    break;
case "subject":
	$extra=hesk_input($_GET['subject'],$hesklang['enter_subject']);
	$sql .= "`subject` LIKE '%$extra%' ";
	break;
default:
    hesk_error($hesklang['invalid_search']);
}

/* Print admin navigation */
require_once('inc/show_admin_nav.inc.php');

?>

</td>
</tr>
<tr>
<td>

<h3 align="center"><?php echo $hesklang['tickets_found']; ?></h3>

<?php
$maxresults = hesk_isNumber($_GET['limit']) or $maxresults=$hesk_settings['max_listings'];
$thispage = hesk_isNumber($_GET['page']) or $thispage=1;

$query = "what=$what&trackid=$extra&name=$extra&date=$extra&subject=$extra&limit=$maxresults&page=";

/* Get number of tickets and page number */
$result = hesk_dbQuery($sql) or hesk_error("$hesklang[cant_sql]: $sql</p><p>$hesklang[mysql_said]:<br>".mysql_error()."</p><p>$hesklang[contact_webmsater] $hesk_settings[webmaster_mail]");
$all = hesk_dbNumRows($result);
$thispages = ceil($all/$maxresults);
    if ($thispage>$thispages) {$thispage=$thispages;}
$limit_down = (($thispage*$maxresults)-$maxresults);

	echo "<p align=\"center\">";
    printf($hesklang['found_num_tickets']." ",$all);
	for ($i=1; $i<=$thispages; $i++) {
		if($i == $thispage) {echo "<b>$i</b>\n";}
        else {echo "<a href=\"find_tickets.php?$query$i\">$i</a>\n";}
	}
    echo "</p>";

/* We have the full SQL query now, get tickets */
$sql .= " LIMIT $limit_down,$maxresults ";
$result = hesk_dbQuery($sql) or hesk_error("$hesklang[cant_sql]: $sql</p><p>$hesklang[mysql_said]:<br>".mysql_error()."</p><p>$hesklang[contact_webmsater] $hesk_settings[webmaster_mail]");

/* Print the table with tickets */
$random=rand(10000,99999);
?>

<form name="form1" action="delete_tickets.php" method="POST">

<div align="center">
<center>
<table border="0" width="750" cellspacing="1" cellpadding="3" class="white">
<tr>
<td class="admin_white">&nbsp;</td>
<td class="admin_white"><?php echo $hesklang['trackID']; ?></td>
<td class="admin_white" align="center"><?php echo $hesklang['timestamp']; ?></td>
<td class="admin_white"><?php echo $hesklang['name']; ?></td>
<td class="admin_white"><?php echo $hesklang['subject']; ?></td>
<td class="admin_white" align="center"><?php echo $hesklang['status']; ?></td>
<td class="admin_white" align="center"><?php echo $hesklang['priority']; ?></td>
</tr>

<?php
while ($ticket=hesk_dbFetchAssoc($result))
{
	if ($i) {$color="admin_gray"; $i=0;}
	else {$color="admin_white"; $i=1;}

    if ($ticket['status']) {$ticket['status']="<font class=\"open\">$hesklang[open]</font>";}
	else {$ticket['status']="<font class=\"resolved\">$hesklang[close]</font>";}

    if ($ticket['priority']==1) {$ticket['priority']="<font class=\"important\">$hesklang[high]</font>";}
    elseif ($ticket['priority']==2) {$ticket['priority']="<font class=\"medium\">$hesklang[medium]</font>";}
	else {$ticket['priority']=$hesklang['low'];}

    $ticket['dt']=hesk_formatDate($ticket['dt']);

//    list($date,$hour) = explode(' ',$ticket[dt]);

echo <<<EOC
<tr>
<td class="$color" align="center"><input type="checkbox" name="id[]" value="$ticket[id]"></td>
<td class="$color"><a href="admin_ticket.php?track=$ticket[trackid]&Refresh=$random">$ticket[trackid]</a></td>
<td class="$color" align="center">$ticket[dt]</td>
<td class="$color">$ticket[name]</td>
<td class="$color"><a href="admin_ticket.php?track=$ticket[trackid]&Refresh=$random">$ticket[subject]</a></td>
<td class="$color" align="center">$ticket[status]</td>
<td class="$color" align="center">$ticket[priority]</td>
</tr>

EOC;
} // End while
?>
</table>
</center>
</div>

<p align="center"><input type="hidden" name="a" value="delete">
<input type="submit" value="<?php echo $hesklang['del_selected']; ?>" class="button"></p>

</form>

<hr>

<?php
require_once('inc/show_search_form.inc.php');
?>


<hr width="750">
<p>&nbsp;</p>
<?php

/* Print footer */
require_once('inc/footer.inc.php');
exit();

?>