<?php
/****************************************************************/
/*                         phpStatus                            */
/*                    functions.php file                        */
/*                      (c)copyright 2003                       */
/*                       By hinton design                       */
/*                 http://www.hintondesign.org                  */
/*                  support@hintondesign.org                    */
/*                                                              */
/* This program is free software. You can redistrabute it and/or*/
/* modify it under the terms of the GNU General Public Licence  */
/* as published by the Free Software Foundation; either version */
/* 2 of the license.                                            */
/*                                                              */
/****************************************************************/
if(eregi("functions.php", $HTTP_SERVER_VARS['PHP_SELF'])) {
   header("Location: ../index.php");
   exit();
}

function phpstatus_real_path($path)
{
   global $phpstatus_real_path;
   return (!@function_exists('realpath') || !@realpath($phpstatus_real_path . 'includes/functions.php')) ? $path : @realpath($path);
}

function replace_quotes($text) {
   $replace = str_replace("'", "\'", $text);
   return $replace;
}   

function clean_username($username) {
   $username = substr(htmlspecialchars(str_replace("\'","'",trim($username))),0,25);
   $username = str_replace("'","\'",$username);
   return $username;
}

function clean_input($value, $check_all_patterns = true)
{
   $patterns[0] = '/content-type:/';
   $patterns[1] = '/to:/';
   $patterns[2] = '/cc:/';
   $patterns[3] = '/bcc:/';
   if ($check_all_patterns)
   {
      $patterns[4] = '/\r/';
      $patterns[5] = '/\n/';
      $patterns[6] = '/ /';
      $patterns[7] = '/ /';
   }
   return preg_replace($patterns, "", strtolower(htmlspecialchars($value)));
}
?>