<?php
/** function libary **/
function ifelse($expression,$returntrue,$returnfalse) {
 if($expression) return $returntrue;
 else return $returnfalse;
}

function stripslashes_array(&$array) {
 while(list($key,$val)=each($array)) {
  if($key=="uploadfile") continue;
  if(is_string($val)) $array[$key]=stripslashes($val);
  elseif(is_array($val)) $array[$key]=stripslashes_array($val);
 }
 return $array;
}

function makeimgtag($path,$alt="") {
 return "<img src=\"$path\" ".ifelse($alt,"alt=\"".$alt."\" ","")."border=0>";
}

function makehreftag($url,$text,$target="") {
 return "<a href=\"".$url."\"".ifelse($target," target=\"".$target."\"","").">".$text."</a>";
}

function formatdate($timeformat,$timestamp) {
 global $timezoneoffset;
 $timestamp+=3600*intval($timezoneoffset);
 return gmdate($timeformat, $timestamp);
}

function parse($post, $nosmilies, $smiliepath="") {
 global $db, $searcharray, $replacearray, $smiliecache, $dosmiliescache, $allowbbcode, $allowsmilies, $allowhtml, $allowimages, $docensor, $censorwords, $censorcover;
 
 $post = textwrap($post);
 
 if($allowhtml==0) {
  $post = str_replace("&lt;","&amp;lt;",$post);
  $post = str_replace("&gt;","&amp;gt;",$post);
  $post = str_replace("<","&lt;",$post);
  $post = str_replace(">","&gt;",$post);
 }

 $post = nl2br($post);

 if($allowsmilies==1 && $nosmilies!=1) {
  if(!isset($dosmiliescache)) {
   $dosmiliescache=1;
   $result=$db->query("SELECT * FROM bgb_smilies");
   $count=0;
   while($row=$db->fetch_array($result)) {
    $smiliecache[$count] = $row;
    $smiliecache[$count]['path'] = $smiliepath."images/smilies/smilie-".$row[smilieid].".".$row[smilieextension]; 
    $count++;
   }
   $db->free_result($result);
  } 
  for($i=0;$i<count($smiliecache);$i++) $post=str_replace($smiliecache[$i]['smiliecode'],makeimgtag($smiliecache[$i]['path'],$smiliecache[$i]['smilietitle']), $post);
 }
 
 if($allowbbcode) {
  if(!isset($searcharray) || !isset($replacearray)) {
   $searcharray[]="/\[url=(['\"]?)(www\.)([^\"']*)\\1](.*)\[\/url\]/siU";
   $replacearray[]="<a href=\"http://www.\\3\" target=\"_blank\">\\4</a>";
   $searcharray[]="/\[url=(['\"]?)([^\"']*)\\1](.*)\[\/url\]/siU";
   $replacearray[]="<a href=\"\\2\" target=\"_blank\">\\3</a>";
   $searcharray[]="/\[url](www\.)([^\"]*)\[\/url\]/siU";	
   $replacearray[]="<a href=\"http://www.\\2\" target=\"_blank\">\\2\\3</a>";
   $searcharray[]="/\[url]([^\"]*)\[\/url\]/siU";	
   $replacearray[]="<a href=\"\\1\" target=\"_blank\">\\1</a>";
   $searcharray[]="/\[img]([^\"]*)\[\/img\]/siU";	
   if($allowimages) $replacearray[]="<img src=\"\\1\" border=0>";
   else $replacearray[]="<a href=\"\\1\" target=\"_blank\">\\1</a>";
  
   $threeparams = "/\[%s=(['\"]?)([^\"']*),([^\"']*)\\1](.*)\[\/%s\]/siU";
   $twoparams = "/\[%s=(['\"]?)([^\"']*)\\1](.*)\[\/%s\]/siU";
   $oneparam = "/\[%s](.*)\[\/%s\]/siU"; 
 
   $result = $db->query("SELECT codetag,replaces,params FROM bgb_codes");

   while($row = $db->fetch_array($result)) {
    if($row[params]==1) $search = sprintf($oneparam, $row[codetag], $row[codetag]);
    if($row[params]==2) $search = sprintf($twoparams, $row[codetag], $row[codetag]);
    if($row[params]==3) $search = sprintf($threeparams, $row[codetag], $row[codetag]);
        	
    $searcharray[] = $search;
    $replacearray[] = $row[replaces];
   }
  }  
  $post = preg_replace($searcharray, $replacearray, $post);
 }
 
 if($docensor==1) {
  $censorwords=explode("\r\n",$censorwords);
  $censorsearch=array();
  $censorreplace=array();
  for($i=0;$i<count($censorwords);$i++) {
   $censorwords[$i]=trim($censorwords[$i]);
   if(!$censorwords[$i]) continue;
   
   if(preg_match("/\{([^=])=([^=])\}/si",$censorwords[$i],$exp)) {  
    $censorsearch[] = "/([\s]{1})$exp[0]([\s]{1})/si"; 	                		
    $censorreplace[] = "\\1".$exp[1]."\\2";
    $censorsearch[] = "/^$exp[0]([\s]{1})/si"; 	                		
    $censorreplace[] = $exp[1]."\\1";
    $censorsearch[] = "/([\s]{1})$exp[0]$/si"; 	                		
    $censorreplace[] = "\\1".$exp[1];
   }
   elseif(preg_match("/\{([^=])\}/si",$censorwords[$i],$exp)) {
    $censorsearch[] = "/([\s]{1})$exp[0]([\s]{1})/si"; 	                		
    $censorreplace[] = "\\1".strrepeat($censorcover, strlen($exp[0]))."\\2";
    $censorsearch[] = "/^$exp[0]([\s]{1})/si"; 	                		
    $censorreplace[] = strrepeat($censorcover, strlen($exp[0]))."\\1";
    $censorsearch[] = "/([\s]{1})$exp[0]$/si"; 	                		
    $censorreplace[] = "\\1".strrepeat($censorcover, strlen($exp[0]));
   }
   elseif(preg_match("/([^=])=([^=])/si",$censorwords[$i],$exp)) $post=str_replace($exp[0],$exp[1],$post);
   else $post=str_replace($exp[0],strrepeat($censorcover, strlen($exp[0])),$post);
  }
  if(count($censorsearch)>0 && count($censorreplace)>0) $post = preg_replace($censorsearch, $censorreplace, $post);
 }
 return $post;
}

function makepagelink($link,$page,$pages,$char='?') {
 global $template;
 $pagelink = $template->get("page")." ".$page."/".$pages.": ";
 
 if($page-5>1) $pagelink.="[".makehreftag($link.$char."page=1","&laquo;")."] ";
 if($page>1) $pagelink.="[".makehreftag($link.$char."page=".($page-1),"")."] ";
 
 $count = ifelse($page+5>=$pages,$pages,$page+5);
 for($i=$page-5;$i<=$count;$i++) {
  if($i<1) $i=1;
  if($i==$page) $pagelink.="($i) ";
  else $pagelink.="[".makehreftag($link.$char."page=".($i),$i)."] ";
 }

 if($page<$pages) $pagelink.="[".makehreftag($link.$char."page=".($page+1),"")."] ";
 if($page+5<$pages) $pagelink.="[".makehreftag($link.$char."page=".$pages,"&raquo;")."]";
 
 return $pagelink;
}

function htmlchars($string) {
 $string=str_replace("<","&lt;",$string);
 $string=str_replace(">","&gt;",$string);
 $string=str_replace("\"","&quot;",$string);
 return $string; 
}
 
function htmlchars_array(&$array) {
 while(list($key,$val)=each($array)) {
  if(is_array($val)) $array[$key]=htmlchars_array($val);
  elseif(is_string($val)) $array[$key]=htmlchars($val);  
 }
 return $array;
}

function rehtmlchars($string) {
 $string=str_replace("&lt;","<",$string);
 $string=str_replace("&gt;",">",$string);
 $string=str_replace("&quot;","\"",$string);
 return $string; 
}
 
function rehtmlchars_array(&$array) {
 while(list($key,$val)=each($array)) {
  if(is_array($val)) $array[$key]=rehtmlchars_array($val);
  elseif(is_string($val)) $array[$key]=rehtmlchars($val);  
 }
 return $array;
}

function trim_array(&$array) {
 while(list($key,$val)=each($array)) {
  if(is_array($val)) $array[$key]=trim_array($val);
  elseif(is_string($val)) $array[$key]=trim($val);  
 }
 return $array;
}

function htmlspecialchars_array(&$array) {
 while(list($key,$val)=each($array)) {
  if(is_string($val)) $array[$key]=addslashes(htmlspecialchars($val));
  elseif(is_array($val)) $array[$key]=htmlspecialchars_array($val);
 }
 return $array;
}

function parseURL($post) {
 $urlsearch[]="/([^]_a-z0-9-=\"'\/])((https?|ftp):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\};<>]*)/si";
 $urlsearch[]="/^((https?|ftp):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\};<>]*)/si";
 $urlreplace[]="\\1[URL]\\2\\4[/URL]";
 $urlreplace[]="[URL]\\1\\3[/URL]";
 $emailsearch[]="/([\s])([_a-zA-Z0-9-]+(\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,}))/si";
 $emailsearch[]="/^([_a-zA-Z0-9-]+(\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,}))/si";
 $emailreplace[]="\\1[EMAIL]\\2[/EMAIL]";
 $emailreplace[]="[EMAIL]\\0[/EMAIL]";
 $post = preg_replace($urlsearch, $urlreplace, $post);
 if (strpos($post, "@")) $post = preg_replace($emailsearch, $emailreplace, $post);
 return $post;
}

/*
 * functions for php3
 *
 */    
function textwrap($text, $width = 75) {
 if($text) return preg_replace("/([^\n\r ?&\.\/<>\"\\-]{".$width."})/i"," \\1\n",$text);
}

function strrepeat($str, $x) {
 for($i=0;$i<$x;$i++) $returnstr.=$str;
 return $returnstr;
}

function doabstract($text, $length) {
 $read=0;
 for($i=0;$i<strlen($text);$i++) {
  if($text[$i]=='[' && $read<=0) $read++;
  elseif($text[$i]=='[' && $read>0) $read--;
  
  if($text[$i]==']' && $read2<=0) $read2++;
  elseif($text[$i]==']' && $read2>0) $read2--;
    
  $newtext.=$text[$i];
  if($read==0 && $read2==0) $length--;
  if($length==0 && $read==0 && $read2==0) break;
 }
 return $newtext;
}
?>