<?php

parse_config();

require("src/config.inc.php");

function cgi_rpc($data) {
	
	global $C;
	
	$ret = Array();
	$ret['err'] = "900";
	
	if(count($data) == 0) {
		
		return $ret;
	}
	
	$url = "http://".$_SERVER['HTTP_HOST']."/".$C['cgi_name']."/picosource.cgi?act=rpc&";
	
	$user 	= $_SESSION['user'];
	
	if($user == "admin") {
		
		$desc['pass'] = $C['admin_pass'];
	
	} else {
		
		$desc = getdesc($user);
	}
	
	$url .= "user=".urlencode($user)."&pass=".urlencode($desc['pass']);
	
	foreach ($data as $ck=>$cv) {
		
		if($ck != "") {
			
			$url .= "&".urlencode($ck)."=".urlencode($cv);
		}
	}
	
	$cgf = @fopen($url,"r");
	
	if(!$cgf) {
		
		$ret['err'] = "404";
		return $ret;
	}
	
	
	while(!feof($cgf)) {
		
		$ln = fgets($cgf,4096);
		$lin = trim($ln);
		
		if($lin != "") {
			
			list($rk,$rv) = explode("=",$lin);
			
			$ret[trim($rk)] = trim($rv);
		}	
	}
	fclose($cgf);
	
	return $ret;
}

function rpcerror($res) {
	
	global $L;
	
	if($res['err'] == "200") {
		
		return "";
	}
	
	if($L[$res['err']] != "") {
		
		$str = 	$res['str'];
		$esr = 	$res['errstr'];
		
		$err = "";
		
		if($str != "") {
			
			$err .= $str;
		}
		
		if($esr != "") {
			
			if($str == "") {
				
				$err .= "[".$esr."]";
			
			} else {
				
				$err .= " [".$esr."]";
			}
		}
		
		if($err != "") {
			
			$err = " (".$err.")";
		}
		
		return "RPC: ".$L[$res['err']].$err;
	
	} else {
		
		return "RPC: ".$res['err'];
	}
}

function savedesc($user,$data) {

	global $C,$L;
	
	$prev = getdesc($user);
	
	$tow = Array();
		
	foreach ($prev as $pk=>$pv) {
		
		if(array_key_exists("d_".$pk,$data)) {
			
			$tow["d_".$pk] = $data["d_".$pk];
		
		} else {
			
			$tow["d_".$pk] = $pv;
		}
		
	}
	
	if($C['use_rpc'] == 1) {
		
		$tow['cmd'] = "saveuser";
		$tow['d_user'] = $user;
		
		//echo "<pre>";
		//print_r(cgi_rpc($tow));
		//echo "</pre>";
		
		return rpcerror(cgi_rpc($tow));
	}
		
	$ff = @fopen("./users/".$user."/desc.txt","w");
	flock($ff,LOCK_EX);
			
	if(!$ff) {
		
		return $L['wusre'];
	}

	if(fputs($ff,"password=".$tow['d_password']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"maxusers=".$tow['d_maxusers']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"bitrate=".$tow['d_bitrate']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"ctype=".$tow['d_ctype']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"info=".$tow['d_info']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"desc=".$tow['d_desc']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"genre=".$tow['d_genre']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"intro=".$tow['d_intro']."\nbanner=".$tow['d_banner']."\nrhost=".$tow['d_rhost']."\nruser=".$tow['d_ruser']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	if(fputs($ff,"arelay=".$tow['d_arelay']."\n") == -1) {
		
		fclose($ff);
		return $L['werror']."<br>".$L['wspace'];		
	}
	
	flock($ff,LOCK_UN);
	fclose($ff);
	
	return "";
}

function unhtmlentities ($string) {
	
    $trans_tbl = get_html_translation_table (HTML_ENTITIES);
    $trans_tbl = array_flip ($trans_tbl);
    return strtr ($string, $trans_tbl);
}


function frame_start($x="",$y="",$align="left") {
	
	if($x != "") {
		
		$fx = "width=\"".$x."\"";
	}
	
	if($y != "") {
		
		$fy = "height=\"".$y."\"";
	}
	
	echo "<table align=\"".$align."\" cellpadding=\"6\" ".$fx." ".$fy."><tr><td align=\"".$align."\" class=\"frame\">";
}

function frame_end() {
	
	echo "</td></tr></table>";
}

function getdesc($user) {
		
	$ret = Array();
	
	$cf = @fopen("./users/".$user."/desc.txt","r");
	
	if(!$cf) {
		
		return 0;
	}		
	
	flock($cf,LOCK_EX);
	
	while(!feof($cf)) {
		
		$line = fgets($cf,4096);
		$line = trim($line);
		
		if($line != "") {
			
			list($kv,$vl) = explode("=",$line);
			$kv = trim($kv);
			$vl = trim($vl);
			
			if($kv != "") {
			
				$ret[$kv] = $vl;	
			}
		}
	}
	
	flock($cf,LOCK_UN);
	fclose($cf);
	
	return $ret;
}

function ftime($file) {

	if(file_exists($file)) {	
		
		$dd = stat($file);
		clearstatcache();
		return $dd[10];
	
	} else {
		
		clearstatcache();
		return 0;
	}
}

function isalive($user) {
	
	global $C;
	
	list($pid) = getuserfile($user,"pid");
	
	if((time() - ftime($pid)) > $C['online_time']) {
			
		return 0;
	
	} else {
		
		return 1;
	}
}

function getpeak($user) {
	
	@$fp = fopen("./users/".$user."/peak.txt","r");
	
	if($fp) {
		
		$peak = fgets($fp,4096);
		$peakt = fgets($fp,4096);
		
		$ret['peak'] = trim($peak);
		$ret['peaktime'] = trim($peakt);
		
	} else {
		
		$ret['peak'] = 0;
		$ret['peaktime'] = 0;
	}
	
	return $ret;
}

function getuserfile($user,$type="port",$val="*") {
	
	$path = "./users/".$user;
	
	if($type == "port") {
		
		$path = "./users/".$user."/ports";
	}
	
	if ($dir = @opendir($path)) {
		
		$c = 0;
		$ret = Array();
		
		while (($file = readdir($dir)) !== false) { 
		
			if(is_file($path."/".$file)) {
    		
    			if(preg_match("/\.".$type."$/i", $file)) {
					
					$file = preg_replace("/\.".$type."$/i","",$file);
					
					if($val != "*") {
						
						if(preg_match("/".$val."/i", $file)) {
							
							if($type == "port") {
								
								list($rel) = explode(".",$file);
								
								if($rel != "relay") {
															
									$ret[$c++] = $path."/".$file.".".$type;
								}
							
							} else {
							
									$ret[$c++] = $path."/".$file.".".$type;
							
							}
						}
						
					} else {
						
						if($type == "port") {
								
							list($rel) = explode(".",$file);
								
							if($rel != "relay") {
																						
								$ret[$c++] = $path."/".$file.".".$type;
							}
						
						} else {
						
							$ret[$c++] = $path."/".$file.".".$type;
							
						}
					}
				}
			}
		}
  		
  		closedir($dir);
	
	}
	
	return $ret;
}

function parse_config() {
	
	global $C;
	
	@$cf = fopen("./users/config.txt","r");
	
	if(!$cf) {
		return;
	}		
	
	flock($cf,LOCK_EX);
	
	while(!feof($cf)) {
		
		$line = fgets($cf,4096);
		
		$line = trim($line);
		
		if (!preg_match("/^\#/i", $line) && ($line != "")) {

			$dp = explode(" ",$line);
		
			$ck = strtolower(trim($dp[0]));
			$cv = trim($dp[1]);
			
			$C[$ck] = $cv;
		}
	}
	
	flock($cf,LOCK_UN);
	fclose($cf);
}

function setconfig($data) {
	
	@$cf = fopen("./users/config.txt","r");
	
	if(!$cf) {
		return 0;
	}		
	
	flock($cf,LOCK_EX);
	
	@$out = fopen("./users/config.txt.tmp","w+");
	
	if(!$out) {
		
		flock($cf,LOCK_UN);
		fclose($cf);
		return 0;
	}
	
	$ferr = 0;
	
	while(!feof($cf)) {
		
		$rline = fgets($cf,4096);
		
		$line = trim($rline);
		
		if (!preg_match("/^\#/i", $line) && ($line != "")) {

			$dp = explode(" ",$line);
		
			$ck = strtolower(trim($dp[0]));
			$cv = trim($dp[1]);
			
			if(array_key_exists($ck,$data)) {
				
				$rline = $ck." ".$data[$ck]."\n";			
				
			}
	
		}
		
		if(fputs($out,$rline) == -1) {
		
			$ferr = 1;
		}
	}
	
	fclose($out);
	
	flock($cf,LOCK_UN);
	fclose($cf);
	
	unlink("./users/config.txt");
	rename("./users/config.txt.tmp","./users/config.txt");
	chmod("./users/config.txt",0666);
	
	if($ferr == 1) {
		
		return 0;
		
	} else {
	
		return 1;
	}
	
}

function getdata($user) {
	
	$desc = getdesc($user);
	
	if($desc == 0) {
	
		return 0;
	}
	
	if($desc['bitrate'] == "") {
		
		$desc['bitrate'] = "0";
	}
	
	$desc['alive'] = isalive($user);
		
	$desc['listeners'] = count(active($user));
	
	$peak = getpeak($user);
	
	$desc['peak'] = $peak['peak'];
	$desc['peaktime'] = $peak['peaktime'];
	
	$desc['rinfo'] = $desc['info'];
	
	if($desc['rhost'] != "norelay") {
		
		$desc['info'] = "[R] " . $desc['info'];
	}
	
		
	return $desc;
}

function active($user) {
	
	global $C;
	
	$ret = Array();
	$c = 0;
	
	$ports = getuserfile($user,"port");
	
	if(count($ports) > 0) { 
		
		foreach ($ports as $oport) {
		
			if((time() - ftime($oport)) < $C['idle_timeout']) {
			
				$ret[$c++] = $oport;
			}
		
		}
	}
	
	return $ret;
}

function zapdir($dirname) {
	
	$er = 0;
	
	if ($dir = @opendir($dirname)) {
		
		while (($file = readdir($dir)) !== false) { 
			
			if(is_file($dirname."/".$file)) {
				
				if(!@unlink($dirname."/".$file)) {
					
					$er++;
				}
			
			} else {
				
				if(($file != ".") && ($file != "..")) {
			
					$er = $er + zapdir($dirname."/".$file);
				}
			}
		}
		
		if(!@rmdir($dirname)) {
			
			$er++;
		}
	
	} else {
		
		return 1;
	}
	
	return $er;
}

function listusers() {
	
	$picouser = "./users";
		
	$ret = Array();
	$c = 0;
	if ($dir = @opendir($picouser)) {
		
		while (($file = readdir($dir)) !== false) { 
		
			if(is_dir($picouser."/".$file)) {
    	
    			if(($file != ".") && ($file != "..")) {
					
					if(file_exists($picouser."/".$file."/desc.txt")) {
						
						$ret[$c++] = $file;
					}
				}
			}
		}
  		
  		closedir($dir);
	
	} else {
		
		$ret[0] = "err";
		return $ret;
	}
	
	sort($ret);
	return $ret;
}

function listrelay($user) {
	
	$frel = getuserfile($user,"relay");
	
	$ret = Array();
	$cc = 0;
	
	if(count($frel) > 0) {
		
		foreach ($frel as $rfile) {
			
			$fp = 0;
			$fp = @fopen($rfile,"r");
			
			if($fp) {
			
				$ret[$cc]['id'] = basename($rfile);
				$ret[$cc]['host'] = trim(fgets($fp,4096));		
				$ret[$cc]['user'] = trim(fgets($fp,4096));
				$ret[$cc]['pass'] = trim(fgets($fp,4096));
			
				$cc++;
			
				fclose($fp);
			
			}
		
		}
	
	} else {
	
		return 0;
	}
	
	return $ret;
	
}

function setpwd($dir,$user,$pass) {
	
	$fp = @fopen($dir."/.htaccess","w");
	
	if(!$fp) {
		
		return 1;
	}
	
	// wrong pwd crypt: my ws don't like... so deny all
	
	fputs($fp,"AuthUserFile ".$dir."/.htpasswd\nAuthGroupFile /dev/null\nAuthName \"PicoSreamer restricted area\"\nAuthType Basic\n\n<Limit GET>\norder deny,allow\ndeny from all\nrequire user ".$user."\n</Limit>\n");
	
	fclose($fp);
	
	chmod($dir."/.htaccess",0666);

	$fw = @fopen($dir."/.htpasswd","w");
	
	if(!$fw) {
		
		@unlink($dir."/.htaccess");
		return 1;
	}
	
	fputs($fw,$user.":".des($pass)."\n");
	
	fclose($fw);
	
	chmod($dir."/.htpasswd",0666);

	return 0;	
}

function des($str) {
 
  $saltchars = array(
   'a','b','c','d','e','f','g','h','i','j','k','l','m',
   'n','o','p','q','r','s','t','u','v','w','x','y','z',
   'A','B','C','D','E','F','G','H','I','J','K','L','M',
   'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
   '1','2','3','4','5','6','7','8','9','0','.','/'
  );

  srand((double)microtime()*1000000);

  $CRYPT_STD_DES  = 1;
  $saltcount      = 2;
 
  for ($i=0; $i<$saltcount; $i++) {
 
    $des_salt .= $saltchars[rand(0,count($saltchars))];
 
  }

  return crypt($pass,$des_salt);
}

function anilogo() {

$js = "	<script type=\"text/javascript\">											\n";
$js.= "		                                                                        \n";
$js.= "		var pos = 0;                                                            \n";
$js.= "		function lamp() {                                                       \n";
$js.= "			                                                                    \n";
$js.= "			if((pos == 0) || (pos == 8)) {                                                      \n";
$js.= "				                                                                \n";
$js.= "				document.getElementById('ls1').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ls2').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ls3').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld1').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ld2').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld3').style.visibility = 'hidden';     \n";
$js.= "				                                                                \n";
$js.= "			}                                                                   \n";
$js.= "			                                                                    \n";
$js.= "			if((pos == 1) || (pos == 9)) {                                                      \n";
$js.= "				                                                                \n";
$js.= "				document.getElementById('ls1').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ls2').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ls3').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld1').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ld2').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ld3').style.visibility = 'hidden';     \n";
$js.= "				                                                                \n";
$js.= "			}                                                                   \n";
$js.= "			                                                                    \n";
$js.= "			if((pos == 2) || (pos == 10)) {                                                      \n";
$js.= "				                                                                \n";
$js.= "				document.getElementById('ls1').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ls2').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ls3').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ld1').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld2').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ld3').style.visibility = 'visible';    \n";
$js.= "				                                                                \n";
$js.= "			}                                                                   \n";
$js.= "			                                                                    \n";
$js.= "			if((pos == 3) || (pos == 11)) {                                                      \n";
$js.= "				                                                                \n";
$js.= "				document.getElementById('ls1').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ls2').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ls3').style.visibility = 'visible';    \n";
$js.= "				document.getElementById('ld1').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld2').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld3').style.visibility = 'visible';    \n";
$js.= "				                                                                \n";
$js.= "			}                                                                   \n";
$js.= "			                                                                    \n";
$js.= "			if((pos == 4) || (pos == 11)) {                                                      \n";
$js.= "				                                                                \n";
$js.= "				document.getElementById('ls1').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ls2').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ls3').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld1').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld2').style.visibility = 'hidden';     \n";
$js.= "				document.getElementById('ld3').style.visibility = 'hidden';     \n";
$js.= "				                                                                \n";
$js.= "			}                                                                   \n";
$js.= "			                                                                    \n";
$js.= "			pos++;                                                              \n";
$js.= "			if(pos > 50) {                                                       \n";
$js.= "				                                                                \n";
$js.= "				pos = 0;                                                        \n";
$js.= "			}                                                                   \n";
$js.= "		}                                                                       \n";
$js.= "		                                                                        \n";
$js.= "	</script>                                                                   \n";
	
	$lstr  = "<table cellpadding=\"0\" celspacing=\"0\"><tr>";
	
	$lstr .= "<td align=\"right\" valign=\"center\">";
	
	$lstr .= "<span id=\"ls3\" style=\"position: relative; color: black; font-family: Tahoma, Verdana; font-size: 24px; visibility: hidden\">(";
	$lstr .= "<span style=\"position: absolute; top: -1px; left: -1px; color: white; font-family: Tahoma, Verdana; font-size: 24px\">(</span></span>";
	
	$lstr .= "</td>";
	
	$lstr .= "<td align=\"right\" valign=\"center\">";
	
	$lstr .= "<span id=\"ls2\" style=\"position: relative; color: black; font-family: Tahoma, Verdana; font-size: 22px; visibility: hidden\">(";
	$lstr .= "<span style=\"position: absolute; top: -1px; left: -1px; color: white; font-family: Tahoma, Verdana; font-size: 22px\">(</span></span>";
	
	$lstr .= "</td>";
	
	$lstr .= "<td align=\"right\" valign=\"center\">";
	
	$lstr .= "<span id=\"ls1\" style=\"position: relative; color: black; font-family: Tahoma, Verdana; font-size: 20px; visibility: hidden\">(";
	$lstr .= "<span style=\"position: absolute; top: -1px; left: -1px; color: white; font-family: Tahoma, Verdana; font-size: 20px\">(</span></span>";
	
	$lstr .= "</td>";
	
	$lstr .= "<td style=\"padding-top: 2px\" align=\"center\" valign=\"center\">";
	$lstr .= "<span style=\"position: relative; color: black; font-family: Tahoma, Verdana; font-size: 26px\">PicoStreamer";
	$lstr .= "<span style=\"position: absolute; top: -1px; left: -1px; color: white; font-family: Tahoma, Verdana; font-size: 26px\">PicoStreamer</span></span>";
	$lstr .= "</td>";

	$lstr .= "<td align=\"right\" valign=\"center\">";
	
	$lstr .= "<span id=\"ld1\" style=\"position: relative; color: black; font-family: Thaoma, Verdana; font-size: 20px; visibility: hidden\">)";
	$lstr .= "<span style=\"position: absolute; top: -1px; left: -1px; color: white; font-family: Thaoma, Verdana; font-size: 20px\">)</span></span>";
	
	$lstr .= "</td>";
	
	$lstr .= "<td align=\"right\" valign=\"center\">";
	
	$lstr .= "<span id=\"ld2\" style=\"position: relative; color: black; font-family: Thaoma, Verdana; font-size: 22px; visibility: hidden\">)";
	$lstr .= "<span style=\"position: absolute; top: -1px; left: -1px; color: white; font-family: Thaoma, Verdana; font-size: 22px\">)</span></span>";
	
	$lstr .= "</td>";
	
	$lstr .= "<td align=\"right\" valign=\"center\">";
	
	$lstr .= "<span id=\"ld3\" style=\"position: relative; color: black; font-family: Thaoma, Verdana; font-size: 24px; visibility: hidden\">)";
	$lstr .= "<span style=\"position: absolute; top: -1px; left: -1px; color: white; font-family: Thaoma, Verdana; font-size: 24px\">)</span></span>";
	
	$lstr .= "</td>";
	
	$lstr .= "</tr></table>";
	

$jf = "<script type=\"text/javascript\"> setInterval(\"lamp()\",80); </script>";

	return $js.$lstr.$jf;	
}

function start_page($cpad="list") {
	
	global $C,$L,$auth,$lang;	
		
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $lang; ?>" lang="<?php echo $lang; ?>">
<meta http-equiv="Content-Language" content="<?php echo $lang; ?>">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $L['charset']; ?>" />
<title><?php echo $C['title_prefix'] . ": " . get_title(); ?></title>
<link rel="stylesheet" href="style.php" type="text/css" />
<script type="text/javascript">
/*******************************************************
COOKIE FUNCTIONALITY
Based on "Night of the Living Cookie" by Bill Dortch
(c) 2003, Ryan Parman
http://www.skyzyx.com
Distributed according to SkyGPL 2.1, http://www.skyzyx.com/license/
*******************************************************/
function cookie(name, value, expires, path, domain, secure)
{
	// Passed Values
	this.name=name;
	this.value=value;
	this.expires=expires;
	this.path=path;
	this.domain=domain;
	this.secure=secure;

	// Read cookie
	this.read=function()
	{
		// To allow for faster parsing
		var ck=document.cookie;

		var arg = this.name + "=";
		var alen = arg.length;
		var clen = ck.length;
		var i = 0;

		while (i < clen)
		{
			var j = i + alen;
			if (ck.substring(i, j) == arg)
			{
				var endstr = ck.indexOf (";", j);
				if (endstr == -1) endstr = ck.length;
				return unescape(ck.substring(j, endstr));
			}
			i = ck.indexOf(" ", i) + 1;
			if (i == 0) break;
		}
		return null;
	}

	// Set cookie
	this.set=function()
	{
		// Store initial value of "this.expires" for re-initialization.
		expStore=this.expires;

		// Set time to absolute zero.
		exp = new Date();
		base = new Date(0);
		skew = base.getTime();
		if (skew > 0)  exp.setTime (exp.getTime() - skew);
		exp.setTime(exp.getTime() + (this.expires*24*60*60*1000));
		this.expires=exp;

		document.cookie = this.name + "=" + escape (this.value) + 
				((this.expires) ? "; expires=" + this.expires.toGMTString() : "") + 
				((this.path) ? "; path=" + this.path : "") + 
				((this.domain) ? "; domain=" + this.domain : "") + 
				((this.secure) ? "; secure" : "");

		// Re-initialize
		this.expires=expStore;
	}

	// Kill cookie
	this.kill=function()
	{
		document.cookie = this.name + "=" + 
				((this.path) ? "; path=" + this.path : "") + 
				((this.domain) ? "; domain=" + this.domain : "") + 
				"; expires=Thu, 01-Jan-70 00:00:01 GMT";
	}

	// Change cookie settings.
	this.changeName=function(chName) { this.kill(); this.name=chName; this.set(); }
	this.changeVal=function(chVal) { this.kill(); this.value=chVal; this.set(); }
	this.changeExp=function(chExp) { this.kill(); this.expires=chExp; this.set(); }
	this.changePath=function(chPath) { this.kill(); this.path=chPath; this.set(); }
	this.changeDomain=function(chDom) { this.kill(); this.domain=chDom; this.set(); }
	this.changeSecurity=function(chSec) { this.kill(); this.secure=chSec; this.set(); }
}


function setCookie(nom,val) {
	
	new cookie(nom,val,365*4,'/').set();
}

function one(vv) {
	
	alert(vv);
}

function relang(lng) {
	
	setCookie("lang",lng);
	
	wl = window.location.href;
	if(wl.indexOf("?") == -1) {
		
		nwl = wl + "?setlang=" + lng;
		
	} else {
		
		nwl = wl + "&setlang=" + lng;
		
	}
	
	window.location.href = nwl;
}

</script>
</head>
<body>
<table cellspacing="0" cellpadding="0" border="0" width="100%">
<tr>
	<td><?php logo(); ?></td><td width="90%" align="center"><?php banner(); ?></td>
</tr>
</table><br>&nbsp;<br>
<?php navbar($cpad); ?>
<table border="0" cellspacing="0" cellpadding="6" width="100%">
<tr><td align="center" class="logbar"><table border="0" cellspacing="0" cellpadding="4" width="100%"><tr>
<td align="left" width="99%"><?php
langbar();
?></td>
<?php if($auth != "") {
echo "<td width=\"1%\" align=\"right\" class=\"logname\">";
echo $_SESSION['user']."&nbsp;&nbsp;<a href=\"".$_SERVER['SCRIPT_NAME']."?logout=yes\">".$L['logout']."</a>";
echo "</td>";
} ?>
</tr></table></td></tr>
<tr><td class="content">
<?php
}

function langbar() {
	
	global $lang,$L;
	
	$lans = listlang();
	
	foreach ($lans as $lng) {
		
		if($lang != $lng) {	
			
			echo "<a href=\"javascript:relang('".$lng."');\"><img alt=\"".$L['lang']." ".strtoupper($lng)."\" border=\"0\" src=\"./img/flags/".$lng.".gif\"></a>&nbsp;";
		}
	}
}

function end_page() { ?>
</td></tr></table>
<p align="center" class="sign"><?php echo base64_decode("UGljb1N0cmVhbWVyIDIuMCAmY29weTsyMDA0IDxhIGNsYXNzPSJzaWduIiBzdHlsZT0iY29sb3I6ICM3Nzc3NzciIGhyZWY9Imh0dHA6Ly93d3cudmluejQ4Ni5jb20iPnZpbno0ODYuY29tPC9hPg=="); ?></p>
</body>
</html>
<?php }

function logo() {
?>
<table border="0" cellpadding="4" cellspacing="0">
	<tr><td align="center"><?php echo anilogo(); ?></td></tr>
	<tr><td id="sublogo" align="center">on <?php echo $_SERVER['HTTP_HOST']; ?></td></tr>
</table>
<?php
}

function getme() {
	
	$qr = $_SERVER['QUERY_STRING'];
	
	$pars = explode("&",$qr);
	
	//print_r($pars);
	
	return $_SERVER['SCRIPT_NAME']."?".$pars[0];
}

function banner() {
	
	@readfile("./src/banner.txt");
}

function navbar($cpad) {
	
	global $pads,$C,$auth,$L,$logerr;
	
	echo "<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" id=\"navbar\" align=\"center\"><tr>";
	
	$padlen = count($pads) + 2;
	
	if($auth == "") {
	
		?>
		<td align="right" valign="middle" class="login"><form action="<?php echo getme(); ?>" method="post"><?php echo $L['username']; ?>: <input class="input" type="text" name="user" size="10">&nbsp;&nbsp;<?php echo $L['password']; ?>: <input class="input" type="password" name="pass" size="10">&nbsp;&nbsp;<input class="button" type="submit" name="login" value="<?php echo $L['login']; ?>"></form><br>
		<?php
		if($logerr != "") {
	
			echo "<span style=\"color: red\">".$logerr."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>";
	
		}	
?>
		</td>
		<?php
	} else {
	
		echo "<td id=\"sxpad\">&nbsp;</td>";
	
		foreach ($pads as $kpad=>$npad) {
		
			if($cpad == $kpad) {
			
				echo "<td align=\"center\"  height=\"26\" width=\"160\" class=\"yespad\">".$npad."</td>";
	
			} else {
	
				echo "<td align=\"center\" width=\"160\" class=\"nopad\"><a class=\"nopadlink\" href=\"".$_SERVER['SCRIPT_NAME']."?ind=".$kpad."\">".$npad."</a></td>";		
			}
		}
	
		echo "<td id=\"dxpad\">&nbsp;</td>";
	}
	
	echo "</tr></table>";
}
?>
