#!/usr/bin/perl
#################################################################
#	PicoStreamer 2.0
#	picosource 2.0
#	Vinz486 (c) 2005
#################################################################
$source = 1;

#print "Content-type: text/html\n\n";

# print errors in browser
use CGI::Carp qw(fatalsToBrowser);

# includes
if($libps != 1) { require "libps.2.0.pl"; }
require "libyp.1.0.pl";

# parse input vars from GET
&io_get_query();

# get versions of libs
if($f{'act'} eq "ver") {
	
	&io_printout(&ps_ver());
}

# RPC handling (for php 'damned' strong safe-mode)
if($f{'act'} eq "rpc") {
	
	$fnc = "rpc_".$f{'cmd'};
	
		print "Content-Type: text/plain\n";
		print "Connection: close\n";
	
	if(defined(&$fnc)) {
		
		%rsp = $fnc->();
		
		$sret = "";
		
		foreach $kv (keys %rsp) {
			
			$sret .= $kv . "=" . $rsp{$kv} . "\n";
		}
		
		$sret .= "errstr=".$c_errcode{$rsp{'err'}}."\n";
		
		print "Content-Length: ".length($sret)."\n\n";
		
		print $sret;
		exit;
	
	} else {
		
		print "Content-Length: ".length("err=500\n")."\n\n";
		print "err=500\n";
		exit;
	}
}
#

# retreive user and password
&io_get_user();

# not defined user, print OK
if($f_user eq "") {
	
	&io_printout("OK");
}

# load user vars from desc file
# if no data return err
if(&ps_loaduser() == 0) {
		
	&io_err($NOUSER);
}

# return status
if($f{'act'} eq "alive") {
	
	my $gs = &ps_get_status();
	&logger($D,"act","alive",$gs);
	&io_printout($gs);
}	

# return the stream info
if($f{'act'} eq "getinfo") {
	
	my $gi = &ps_get_info();
	&logger($D,"act","getinfo",$gi);
	&io_printout($gi);
}	

# return the number of listeners
if($f{'act'} eq "listeners") {
	
	my $gap = &ps_count_active_clients();
	&logger($D,"act","listeners",$gap);
	&io_printout($gap);
}

# generate statistics
# $f{'mode'} = simple|shout|ice|csv
if($f{'act'} eq "stats") {
	
	if($f{'mode'} eq "") {
	
		$f{'mode'} = "simple";
	}
	
	&logger($D,"act","stats",$f{'mode'});
	&io_printout(&ps_stats($f{'mode'}));
}

# check password
if($f_pass ne &ps_get_pass()) {
	
	&logger($E,"bad_pass",$f_pass);
	&io_err($NOAUTH);
}

# # # # # # # # # # # # # # # # # # # # #
# from here, all api must be with auth  #
# # # # # # # # # # # # # # # # # # # # #

# output log
if($f{'act'} eq "debug") {
	
	&logger($D,"act","debug",$f{'grep'});
	
	if(&source_debug() == 1) {
		
		print "Debug terminated.";
	
	} else {
	
		print "Error starting debug: " . $!;
	}
	
	exit;
}

# save all source data, if needed
&source_setdata();

# return auth
if($f{'act'} eq "auth") {

	&logger($D,"act","auth");	
	&io_err($OK);
}	

# relay remove
if($f{'act'} eq "remrelay") {
	
	$ar_host = $f{'rhost'};
	$ar_user = $f{'ruser'};
	
	&logger($D,"act","remrelay",$ar_host);
	
	if(($ar_host eq "") || ($ar_user eq "")) {
		
		&logger($E,"remrelay","bad_data",$ar_host);
		&io_err($BADRELAY,"Empty relay data!");
	}
	
	if(&relay_rem($ar_host,$ar_user) == 0) {
	
		&logger($E,"remrelay","not_found",$ar_host);
		&io_err($BADRELAY,$!);
	}
		
	&logger($I,"remrelay",$ar_host,$ar_user);
	&io_err($OK);
}

# relay list
if($f{'act'} eq "listrelay") {
	
	&logger($D,"act","listrelay");
	
	@rre = &relay_list();
	
	$rli = "";
	
	foreach $ore (@rre) {
		
		$rli .= $ore . "\n";
	}	
	
	&io_printout($rli);
}

# relay add
if($f{'act'} eq "addrelay") {
		
	$ar_host = $f{'rhost'};
	$ar_user = $f{'ruser'};
	$ar_pass = $f{'rpass'};
	
	&logger($D,"act","addrelay",$ar_host);
	
	if(($ar_host eq "") || ($ar_host eq "") || ($ar_host eq "")) {
		
		&logger($E,"addrelay","bad_data",$ar_host);
		&io_err($BADRELAY);
	}
	
	if(&relay_add($ar_host,$ar_user,$ar_pass) == 0) {
		
		&logger($E,"addrelay",$ar_host,$!);
		&io_err($ERROR);
	}
	
	&logger($I,"addrelay",$ar_host,$ar_user);
	
	&io_err($OK);
}	

# perform a client reset
if($f{'act'} eq "reset") {
	
	&logger($D,"act","reset");
	
	$resn = &ps_zap_clients(&ps_get_all_clients());
	
	if($f{'mode'} eq "source") {
		
		&ps_zap_source();
	}
	
	&logger($I,"reset",$resn);
	&io_printout($resn . " resets.");
}	

# source request
if($f{'act'} eq "source") {
	
	&logger($D,"act","source");
	
	# install quit handlers so we can quit clear
	&ut_install_sig('QUIT',\&source_catch_quit);
	&ut_install_sig('TERM',\&source_catch_quit);

	# setup UDP socket for sending
	($u_sock,$u_port) = &udp_setup("127.0.0.1");
	if(($u_sock eq "") || ($u_port eq "")) {
	
		&logger($E,"socket",$!);
		&io_err($ERROR);
	}
	
	&logger($I,"start",$gsource,&ps_get_bitrate());
	
	# time of start
	my $time_start = time();
	
	# init clients list
	&source_update();
	
	# set alive
	&source_alive();
		
	# init time table
	&ut_timer_set("clients",$c_clients_search_interval,	\&source_update		);
	&ut_timer_set("alive",	$c_source_ping_interval,	\&source_alive		);
	&ut_timer_set("purge",	$c_idle_check_interval,		\&source_purge		);
	&ut_timer_set("buffer",	$c_buffer_avg,				\&source_buffer_avg	);
	&ut_timer_set("peak",	$c_log_peak,				\&source_log_peak	);
	&ut_timer_set("relay",	$c_relay_scan_interval,		\&source_relay_scan	);
	&ut_timer_set("ypages",	$c_ping_yp_interval,		\&source_ping_yp	);
	
	$buff = "";
	$buff_avg = 0;
	$b_c = 0;
	
	# time to add to idle
	$stime = time();
	$sdelay = $c_reader_ping_interval * 2;
	
	# MAIN broadcast loop
	while(($rdd = &io_stdread($buff, $c_buffer_size)) > 0) {
		
		# if read block, store delay
		$ntime = time();
		$sdelay = $ntime - $stime;
		$stime = $ntime;
		 
		# send data to listeners
		&source_out($buff);
		
		$buff_avg += length($buff);
		$b_c++;
		
		# process time table
		&ut_timer_exe();
	}
	
	&relay_zap_all();
	
	&ps_rem_user_file("pid");
		
	&logger($I,"stop",time() - $time_start, $rdd);
	
}

&io_printout("OK");

#################################################

# dispatch data to client
sub source_out {
		
	foreach $nclient (@clients) {
		
		&udp_send($u_sock,"127.0.0.1", $nclient, $_[0]);
	}
}

# ping the yp
sub source_ping_yp {
	
	&logger($T,"source_ping_yp");	
	&yp_start();
}

# log new peaks
sub source_log_peak {
	
	&logger($T,"source_log_peak");	
	
	my $sp = &ps_set_peak();
	if($sp > 0) {
		
		&logger($I,"new_peak",$sp);	
	}
}

# log the buffer size
sub source_buffer_avg {
	
	if($b_c == 0) {
	
		$b_c = 1;
	}
		
	&logger($D,"buffer",int($buff_avg/$b_c));	
	$b_c = 0;
	$buff_avg = 0;
}

# update pid
sub source_alive {
	
	&logger($T,"source_alive",$$);
	&ps_set_source_pid();
}

# update the client list
sub source_update {
		
	@clients = &ps_get_all_clients("port");
	my $rcf = @clients;
	&logger($T,"source_update",$rcf);
}

# purge idle
sub source_purge {
	
	my $zid = &ps_zap_clients(&ps_get_inactive_clients($sdelay));
	if($zip > 0) {
		
		&logger($I,"idle",$zid,$sdelay);
	}
	
	&logger($T,"source_purge",$zid,$sdelay);
}

# find and start relay
sub source_relay_scan {

	&logger($T,"source_relay_scan");
	
	my $fr = &relay_find();
	if($fr > 0) {
		
		&logger($I,"relay","found",$fr);
			
	} else {

		&logger($D,"relay","not_found");
	}	
}

# save stream data
sub source_setdata {
	
	if($f{'act'} eq "source") {
		
		$source_is_relay = 0;
	
		$gsource = &io_get_param("source");
		&logger($T,"source_setdata","source",$gbits);
	
		if($gsource =~m/^Relay-/) {
		
			$source_is_relay = 1;
		
			$s_relay_host = &io_get_param("rhost");
			
			## :80 fix
			($_fhost,$_fport) = split(/\:/,$s_relay_host);
			
			$s_relay_host = $_fhost;
			
			if($_fport ne "80") {
			
				&logger($W,"relay port",$s_relay_host,$_fport);
			
			}
			##
			
			$s_relay_user = &io_get_param("ruser");
		
			&ps_set_rhost($s_relay_host);
			&ps_set_ruser($s_relay_user);
		
			&logger($I,"relay_source",$s_relay_host,$s_relay_user);
				
		} else {
	
			&ps_set_rhost("norelay");
		}
	}
	
	my $gbits = &io_get_param("bits");
	&logger($T,"source_setdata","bits",$gbits);
	if(&ps_set_bitrate($gbits)) {
		&logger($I,"bits",$gbits);
	}
	
	my $ginfo = &io_get_param("info");
	&logger($T,"source_setdata","info",$ginfo);
	if(&ps_set_info($ginfo)) {
		&logger($I,"info",$ginfo);
	}
	
	my $gctype = &io_get_param("ctype");
	&logger($T,"source_setdata","ctype",$gctype);
	if(&ps_set_ctype($gctype)) {
		&logger($I,"ctype",$gctype);		
	}
	
	my $gdesc = &io_get_param("desc");
	&logger($T,"source_setdata","desc",$gdesc);
	if(&ps_set_desc($gdesc)) {
		&logger($I,"desc",$gdesc);		
	}
	
	my $ggenre = &io_get_param("genre");
	&logger($T,"source_setdata","genre",$ggenre);
	if(&ps_set_genre($ggenre)) {
		&logger($I,"genre",$ggenre);			
	}
	
}	

sub source_debug {

	&logger($T,"source_debug",$f{'grep'});			
	
	&ut_install_sig('QUIT',\&source_stop_debug);
	&ut_install_sig('TERM',\&source_stop_debug);
	&ut_install_sig('PIPE',\&source_stop_debug);
		
	$|=1;
	
	my $fgr = $f{'grep'};
	
	print "Content-Type: text/html\n\n<html><head></head><body><pre>\n";
	
	open(FDEB,"tail -f -n1 $ps_logfile |") or return 0;		
	while(<FDEB>) {
		
		if($fgr ne "") {
		
			if($_ =~m/$fgr/) {
				
				print;
			}
		
		} else {
			
			print;
		}
	}
	
	close(FDEB);
	return 1;
}

$source_quit = 0;
sub source_catch_quit {

	
	if($source_quit == 1) {
	
		return;
	}

	$source_quit = 1;
	
	&logger($D,"signal",$_[0]);
	
	# close all handler so main loop jump out
	close(STDIN);
	close(STDOUT);
	&udp_close($u_sock);
	
}


sub source_stop_debug {
	
	close(FDEB);
}
