#!/usr/bin/perl
#################################################################
#	PicoStreamer 2.0                                        	#
#	picoreader 2.0                                              #
#	Vinz486 (c) 2004	                                		#
#################################################################
$reader = 1;

# print errors in browser
use CGI::Carp qw(fatalsToBrowser);

# includes
if($libps != 1) { require "libps.2.0.pl"; }

# parse input vars from GET
&io_get_query();

# retreive user
&io_get_user();

# not defined user, print OK
if($f_user eq "") {
	
	&io_printout("OK");
}

# load user vars from desc file
# if no data return err
if(&ps_loaduser() == 0) {
		
	&io_err($NOUSER);
}

# ban

if(&ps_is_banned($ENV{'REMOTE_ADDR'}) == 1) {

	&io_err($BANNED);
}
#

# return the stream info
if($f{'act'} eq "getinfo") {
	
	my $gi = &ps_get_info();
	&logger($D,"act","getinfo",$gi);
	&io_printout($gi);
}	

# return status
if($f{'act'} eq "alive") {
	
	my $gs = &ps_get_status();
	&logger($D,"act","alive",$gs);
	&io_printout($gs);
}	

# # # # # # # # # # #
# streaming starts  #
# # # # # # # # # # #


# if offline return OFFLINE or push banner file
if(&ps_get_status() == 0) {
	
	if(&ps_get_banner() > 0) {
		
		&logger($D,"offline","banner");
	
		$reader_b_info = "User Offline";
		
		#&io_set_clen(&ut_get_fsize($ps_userdir."banner"));
		&reader_stream_file(&ps_get_banner(),"banner");
	
		exit;

	} else {
	
		&logger($D,"offline","text");
		
		&io_err($OFF);
	}
}

# check if max user reached
my $cus = &ps_count_active_clients();
my $cma = &ps_get_maxusers();

if($cus >= $cma) {
	
	&logger($W,"maxuser",$cus,$cma)

	# check if a relay exists
	&reader_relay();
	
	&io_err($MAXUSERS);
}

# install quit handlers so we can quit clear
&ut_install_sig('QUIT',\&reader_catch_quit);
&ut_install_sig('TERM',\&reader_catch_quit);

# get an UDP port number
($usock,$uport) = &udp_setup("127.0.0.1");

# if error, return NOPORT
if(($usock eq "") || ($uport eq "")) {

	&logger($E,"socket",$!);
	&io_err($NO_PORT);
}

# set the new client
&ps_set_client($uport);

# burrer average data
$buff_avg = 0;
$b_c = 0;

# setup the time table
&ut_timer_set("refresh",	$c_reader_ping_interval,\&reader_refresh	);
&ut_timer_set("buffer",		$c_buffer_avg,			\&reader_buffer_avg	);

# time of start
$time_start = time();

&logger($I,"start");

# strream intro file
if(&ps_get_intro() > 0) {

	&logger($D,"intro");
	
	&reader_stream_file(&ps_get_intro(),"intro");
}

my $red = 2;

# traffic counter
$bytes = 0;
	
# MAIN reader loop
while($red = &udp_recv($usock,$c_buffer_size)) {
	
	# bytes read
	$lred = length($red);
		
	# if a 1 byte length received, stop
	if($lred == 1) {		
		
		&logger($D,"stop_reason","1byte");
		last;
	}
	
	# if writing error, stop
 	if(!(&io_stdwrite($red) > 0)) {
 		
 		&logger($D,"stop_reason","error",$!);
		last;
 	}

	$bytes += $lred;
	$buff_avg += $lred;
	$b_c++;
 	
 	# execute time table
 	&ut_timer_exe();
	
}

&ps_rem_client($uport);

&logger($I,"stop",(time() - $time_start),$bytes);

exit;

####################################################

# refresh client
sub reader_refresh {
	
	&logger($D,"alive",$$,$uport);
	&ps_set_client($uport);
}

# switch to relay
sub reader_relay {
	
	@rlis = &relay_list();
	
	&logger($I,"DEBBBUR",$c_username_max);
	
	$rnum = @rlis;
	
	if($rnum > 0) {
		
		@rdat = split(/,/,$rlis[int(rand($rnum))]);
		
		$exx = $f{'ext'};
		
		if($exx eq "") {
			
			$exx = "mp3";
		}
		
		print "Content-Type: " . &ps_get_ctype() . "\n";
		print "Location: http://" . $rdat[0] . "/" . $c_cgi_name . "/picoreader.cgi?user=" . &ut_url_encode($rdat[1]) . "&ext=" . $exx . "\n\n";  
		&logger($I,"relay_switch",$rdat[0],$rdat[1]);
		exit;
		
	}
}

# log the buffer size
sub reader_buffer_avg {
	
	# aaaaahhhhhrgg division by zero!
	if($b_c == 0) {
		$b_c = 1;
	}
	
	&logger($D,"buffer",int($buff_avg/$b_c));	
	$b_c = 0;
	$buff_avg = 0;
}

# stream a file to stdout
sub reader_stream_file {
	
	if($_[0] == 0) {
		return;
	}
	
	if(-e $ps_userdir . $_[1]) {
		
		my $i = 0;
		
		for($i = 0; $i < $_[0]; $i++) {
		
			my $rbuf ="";
		
			open(BAN, $ps_userdir . $_[1]) or return;
			binmode(BAN);
			
			&logger($T,"reader_stream_file","start",$ps_userdir.$_[1]);
			
			
			$tbuf = 8192;
				
			my $rt = read(BAN,$rbuf,$tbuf);
			while(defined($rt) && $rt != 0) {
			
				
				if($_[1] eq "intro") {
	
					&ut_timer_exe();
				
					$stb = &udp_recv($usock,$c_buffer_size);
			
					$tbuf = length($stb);
			
				} else {
					
					$tbuf = 4096;	
				}
				
				&io_stdwrite($rbuf);
				$rt = read(BAN,$rbuf,$tbuf);
			}
			
			close(BAN);
			&logger($T,"reader_stream_file","stop",$ps_userdir.$_[1]);
		}
	}
}

$reader_quit = 0;
sub reader_catch_quit {

	
	if($reader_quit == 1) {
		
		return;
	}
	
	$reader_quit = 1;
	
	&logger($D,"signal",$_[0]);
	
	# close all handler so main loop jump out
	close(STDIN);
	close(STDOUT);
	&udp_close($usock);
}

