#################################################################
#	PicoStreamer 2.0                                        	#
#	UDP networking library 1.0                                  #
#	Vinz486 (c) 2004	                                		#
#################################################################
$libudp = 1;

# using socket
use Socket;

# set autoflush
$|=1;

# return this file ver
sub udp_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

# _SSOCK already inited?
$_upok = 0;

# send an udp packet
# [0] socket, [1] host, [2] port, [3] data]
# return 1 on error, 0 ok
sub udp_send {
	
	&logger($T,"udp_send",$_[1],$_[2]);
	
	my $USOCK	 = $_[0];
	my $HOSTNAME = $_[1];
	my $PORTNO   = $_[2];
	my $MSG	     = $_[3];
	
	my $ipaddr   = inet_aton($HOSTNAME);
	my $portaddr = sockaddr_in($PORTNO, $ipaddr);

	send($USOCK, $MSG, 0, $portaddr) == length($MSG) or return 1;

	return 0;
}

# create an udp socket
# [0] host
# return (socket,port) or "" on error
sub udp_setup {
		
	my $HOSTNAME = $_[0];
	
	socket(RSOCK, PF_INET, SOCK_DGRAM, getprotobyname("udp")) or return "";
	binmode(RSOCK);
	
	my $ipaddr   = inet_aton($HOSTNAME);
	my $portaddr = sockaddr_in(0, $ipaddr);

	bind(RSOCK, $portaddr) or return "";
	
	my $nport, $naddr;
	($nport, $naddr) = sockaddr_in(getsockname(RSOCK));
   	
   	&logger($T,"udp_setup",$_[0],RSOCK,$nport);

   	return (RSOCK,$nport);
}

# receive an udp packet
# [0] socket, [1] maxlen
sub udp_recv {
	
	&logger($T,"udp_recv",$_[0],$_[1]);
	
	my $URSOCK = $_[0];
	my $maxlen = $_[1];
	my $_MSG = "";
	recv($URSOCK, $_MSG, $maxlen, 0);
	
	return $_MSG;
}

# close udp socket
# [0] socket
sub udp_close {
	
	&logger($T,"udp_close",$_[0]);
	
	close($_[0]);
}

1;