#################################################################
#	PicoStreamer 2.0                                        	#
#	Relay library 1.0                                           #
#	Vinz486 (c) 2004	                                		#
#################################################################
$librelay = 1;

undef(@relays_on);


# return this file ver
sub relay_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

# add a relay entry
sub relay_add {
	
	&logger($T,"relay_add",$_[0],$_[1]);
	
	if(($_[0] eq "") || ($_[1] eq "") || ($_[2] eq "")){
		
		$! = "Relay data is empty!";
		return 0;
	}
	
	my $r_host = $_[0];
	my $r_user = $_[1];
	my $r_pass = $_[2];
	
	if(($r_host eq &ut_this_host()) && ($r_user eq $f_user)) {
		
		$! = "Can't add me as relay!";
		return 0;
	}
	
	open(REL,">" . $ps_userdir . $r_host . "." . $r_user . ".relay") or return 0;
	&ut_lokf(REL);
	
	print REL $r_host . "\n";
	print REL $r_user . "\n";
	print REL $r_pass . "\n";
	
	&ut_unlokf(REL);
	close(REL);
	
	&logger($T,"relay_add","ok",$_[0]);
	
	return 1;
}

# rem a relay entry
sub relay_rem {
	
	if(($_[0] eq "") || ($_[1] eq "")){
		
		$! = "Empty relay data!";
		return 0;
	}
	
	my $rv = &ps_rem_user_file("relay",$_[0].".".$_[1]);
	
	my $rrr = $!;
		
	&relay_zap($_[0].".".$_[1]);
	
	$! = $rrr;
	return $rv;
}

# list relays
sub relay_list {
	
	&logger($T,"relay_list");
		
	my @retl;
	
	my @rli = &ps_get_user_file("relay");
	
	my $ren;
	
	foreach $ren (@rli) {
		
		&logger($T,"relay_list","item",$ren);
		
		push(@retl,&relay_get_data($ren,"csv"));
	}
	
	return @retl;
}

# get host user pass of relay
sub relay_get_data {

	&logger($T,"relay_get_data",$_[0],$_[1]);
	
	if($_[0] eq "") {
		
		return;
	}
	
	open(REL, $ps_userdir . $_[0] . ".relay") or return 0;
	&ut_lokf(REL);
	
	my $rh = <REL>;
	my $ru = <REL>;
	my $rp = <REL>;
	
	chomp($rh);
	chomp($ru);
	chomp($rp);
		
	&ut_unlokf(REL);
	close(REL);
	
	&logger($T,"relay_get_data",$rh,$ru);	
		
	if($_[1] eq "csv") {
		
		return ($rh.",".$ru.",".$rp);
	}

	return ($rh,$ru,$rp);
}

# shutdown a relay
sub relay_zap {

	&logger($T,"relay_zap",$_[0]);
	
	if($_[0] eq "") {
		
		return;
	}

	my $rpid = $relay_list{$_[0]};
	
	if(($rpid ne "") && ($rpid != 0)) {
		
		&ut_kill($rpid);
	
	} else {
		
		&logger($T,"relay_zap","not_found",$_[0]);
	} 
}

# shutdown all relays
sub relay_zap_all {
	
	&logger($T,"relay_zap_all");
	
	my $rza;
	
	foreach $rza (keys %relay_list) {
		
		&logger($T,"relay_zap_all","item",$rza);	
		&relay_zap($rza);
	}
}

# fork a relay process    
sub relay_start {
	
	&ut_install_sig('CHLD','IGNORE');
	&ut_install_sig('CLD','IGNORE');
	
	if (!defined($pid = fork())) {

		&logger($E,"relay","cannot_fork",$!);
		return 0;
	
	} elsif ($pid == 0) {
		
		&relay_child(@_);
		exit;
	} else {
		
		&relay_list_add($_[0],$pid);
		return 1;
	}
}

sub relay_child {
	
	$source = 0;
	$relay = 1;

	&ut_timer_clear();
	
	&ut_remove_sig('QUIT');
	&ut_remove_sig('TERM');
	&ut_remove_sig('PIPE');

	&udp_close($u_sock);
	
	close(STDIN);
	open(STDIN, "/dev/null");
	
	close(STDOUT);
	open(STDOUT, ">/dev/null");
	
	close(STDERR);
	open(STDERR, ">/dev/null");
	
	&relay_run(@_);
	
	exit;
}

# # # # # # # #
# CHILD code  #
# # # # # # # #
 
sub relay_run {
	
	#$relay_host = $_[0];
	
	&logger($I,"start",$_[0]);
	$relay_time_start = time();
	
	($relay_host,$relay_user,$relay_pass) = &relay_get_data($_[0]);
	
	&logger($D,"connecting",$relay_host,$relay_user);
	
	if(&relay_auth() == 0) {
		
		&logger($E,"error",$relay_host.".".$relay_user,"auth failed");
		return;
	}	
	
	# get an UDP port number
	($r_usock,$r_uport) = &udp_setup("127.0.0.1");

	# if error, return NOPORT
	if(($r_usock eq "") || ($r_uport eq "")) {

		&logger($E,"socket","udp socket",$!);
		return;
		
	}

	
	$RSO = &tcp_connect($relay_host,80);
	
	if($RSO eq "") {
	
		&logger($E,"socket",$!);
		return;
	}
	
	print $RSO &relay_header("source");
	
	# set the new port
	&ps_set_client($r_uport,"relay.".$relay_host);

	&ut_timer_set("refresh",	$c_reader_ping_interval,	\&relay_refresh	);

	my $ured = 2;

	# MAIN reader loop
	while($ured = &udp_recv($r_usock,$c_buffer_size)) {
	
		# if a 1 byte length received, stop
		if(length($ured) == 1) {		
		
			&logger($D,"stop_reason","1byte");
			last;
		}
	
		$rp = print $RSO $ured;
		
		# if writing error, stop
 		if($rp != 1) {
 		
 			&logger($D,"stop_reason","error",$!);
			last;
 		}
 		
 		&ut_timer_exe();
	}

	&ps_rem_client($r_uport);
	&udp_close($r_usock);
	&tcp_close($RSO);
	
	&logger($I,"stop",(time() - $relay_time_start));
	
	return;
}

# refresh port
sub relay_refresh {
	
	&logger($D,"alive",$$,$uport);
	&ps_set_client($r_uport,"relay.".$relay_host);
}

sub relay_auth {
	
	my $_rg;
	if(($_rg = &relay_get_code(&relay_connect("auth"))) != 200) {
		
		if($_rg ne "") {
			
			&logger($E,"response",$_rg,$c_errcode{$_rg});
		}
		
		return 0
	
	} else {
		
		return 1;
	}
}

sub relay_get_code {
	
	&logger($T,"relay_get_code",$_[0]);
	
	my ($cde) = split(/ /, $_[0]);
	$cde =~m/^(\d+)$/;
	
	&logger($T,"relay_get_code",$1);
	
	return $1;
}

sub relay_connect {
	
	$cerr = "";
	
	$RCON = &tcp_connect($relay_host,80);
	
	if($RCON eq "") {
		
		&logger($E,"connect",$relay_host,"no_connection");
		return "";
	}
	
	my $hed = &relay_header($_[0]);
	
	print $RCON $hed;
	
	my $las = &relay_get_line($RCON);
	
	&logger($T,"relay_connect","line",$las);
	
	&tcp_close($RCON);
	
	return $las;
}

sub relay_get_line {
	
	&logger($T,"relay_get_line",$_[0]);
	
	my $lv = 0;
	my $han = $_[0];
	
	while($lv == 0) {
		
		my $line = <$han>;
		
		$line = &ut_strip_carriage($line);
		
		if($line eq "") {
			
			$lv = 1;
		}
	}
	
	my $lsa = <$han>;

	return &ut_strip_carriage($lsa);	
}

sub relay_header {
	
	my $rhead;
	
	if($_[0] eq "source") {
		
		$rhead  = "POST /cgi-bin/picosource.cgi?act=" . $_[0] . " HTTP/1.0\n";
		$rhead .= "Content-Length: 1294967295\n";
		$rhead .= "Content-Type: application/octet-stream\n";
    
	} else {
		
		$rhead  = "GET /cgi-bin/picosource.cgi?act=" . $_[0] . " HTTP/1.0\n";
		
	}
	
	
		$rhead .= "Host: " . $relay_host . "\n";
		$rhead .= "Pico-Streamer-Id: " . $relay_user . ":" . $relay_pass . "\n";
		$rhead .= "Pico-Streamer-Info: " . &ps_get_info(1) . "\n";
		$rhead .= "Pico-Streamer-Source: Relay-" . &ut_this_host() . "\n";
		
		if($source_is_relay == 1) {
			
			$rr_host = $s_relay_host;
			$rr_user = $s_relay_user;
		
		} else {
		
			$rr_host = &ut_this_host();
			$rr_user = $f_user;
		
		}
		
		$rhead .= "Pico-Streamer-Rhost: " . $rr_host . "\n";
		$rhead .= "Pico-Streamer-Ruser: " . $rr_user . "\n";
		$rhead .= "Pico-Streamer-Source-Ver: " . $PS_VER . "\n";
		$rhead .= "Pico-Streamer-Bits: " . &ps_get_bitrate() . "\n";
		$rhead .= "Pico-Streamer-CType: " . &ps_get_ctype() . "\n";
		$rhead .= "Connection: close\n\n";
    
    return $rhead;
}

# # # # # # # # # # # 

sub relay_find {
	
	&logger($T,"relay_find");
	
	&relay_ping();
	
	my @frl	= &ps_get_user_file("relay");

	my $r_find;
	my $r_cc = 0;
	
	foreach $r_find (@frl) {
		
		my $rfp = $relay_list{$r_find};
		
		if($rfp eq "") {
			
			&logger($T,"relay_find","new",$r_find);
			&relay_start($r_find);			
			$r_cc++;
		}
	}
	
	my $r_li;
	
	foreach $r_li (keys %relay_list) {
		
		my $rfnd = 0;
		my $rtf;
		
		foreach $rtf (@frl) {
			
			if($rtf eq $r_li) {
				
				$rfnd = 1;
				last;
			}
		}
		
		if($rfnd == 0) {
			
			&logger($T,"relay_find","old",$r_li);
			&relay_zap($r_li);
		}
	}
	
	return $r_cc;
}

sub relay_ping {
	
	my $rpname;
	
	foreach $rpname (keys %relay_list) {
		
		if(&ut_kill($relay_list{$rpname},0) == 0) {
			
			&logger($T,"relay_ping",$rpname,"OFF");
			
			&relay_list_rem($rpname);
			
		
		} else {
		
			&logger($T,"relay_ping",$rpname,"ON");
		
		}
	}
	
}

sub relay_list_rem {
	
	undef(%rt_list);
	
	my $rtname;
	
	foreach $rtname (keys %relay_list) {
		
		if($_[0] ne $rtname) {
			
			$rt_list{$rtname} = $relay_list{$rtname};

		} else {
			
			&logger($T,"list_rem","removed",$rtname);
		}
	}
	
	%relay_list = %rt_list;
}

sub relay_list_add {

	$relay_list{$_[0]} = $_[1];

}

1;