#################################################################
#	PicoStreamer 2.0                                        	#
#	Input/Output library 1.0                                    #
#	Vinz486 (c) 2004	                                		#
#################################################################
$libio = 1;

# enable autoflush
$|=1;
use IO::Handle;
STDOUT->autoflush();

# for windows :-)
binmode(STDIN);
binmode(STDOUT);

# return this file ver
sub io_get_ver {
	
	my ($fid,$vma,$vmi) = split(/\./,__FILE__);
	
	return $vma.".".$vmi;
}

# header sent?
$io_hsent = 0;

# CLength flag
$io_clen = 0;

# set Content-Length header
# [0] length
sub io_set_clen {
	
	&logger($T,"io_set_clen",$_[0]);
	$io_clen = $_[0];
}

# raw write to STDOUT
# [0] data
# return byte written
# undef on error
sub io_stdwrite {
	
	&logger($T,"io_stdwrite",length($_[0]));
	
	if($io_hsent == 0) {
		
		my $_info = &ps_get_info();
		
		if($reader_b_info ne "") {
			
			$_info = $reader_b_info;
		}
		
		syswrite(STDOUT, "Content-Type: " . &ps_get_ctype() . "\n");
				
		if($io_clen > 0) {		
			
			syswrite(STDOUT, "Content-Length: " . $io_clen . "\n");
		}
		
		syswrite(STDOUT, "Cache-Control: no-cache\n");
		syswrite(STDOUT, "Connection: keep-alive\n");
		syswrite(STDOUT, "Expires: Sat, 22 Apr 2000 22:22:22 GMT\n");
		syswrite(STDOUT, "icy-name:" . &ut_url_encode($_info) . "\n");
		syswrite(STDOUT, "icy-genre:" . &ut_url_encode(&ps_get_genre()) . "\n");
		syswrite(STDOUT, "icy-url:http://" . $ENV{"HTTP_HOST"} . "\n");
		syswrite(STDOUT, "icy-pub:1\n");
		#syswrite(STDOUT, "icy-metaint:8192\n");
		syswrite(STDOUT, "icy-br:" . &ps_get_bitrate() . "\n");	
		syswrite(STDOUT, "\n");
		
		$io_hsent = 1;
	}	
	
	return syswrite(STDOUT, $_[0]);
}

# raw read from STDIN
# [0] buffer], [1] length 
# return 0 or undef on eof
sub io_stdread {
	
	&logger($T,"io_stdread",$_[1]);
	return sysread(STDIN, $_[0], $_[1]);
}

# parse the query string
# and set %f with values
sub io_get_query { 
	
	&logger($T,"io_get_query");
	
	my @doubles = split(/&/, $ENV{'QUERY_STRING'});
	
	my $gkv;
	
	foreach $gkv (@doubles) {
		
		my ($gkey, $gvalue) = split(/=/, $gkv);
		
		$gkey =~ tr/+/ /;
		$gkey =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$gvalue =~ tr/+/ /;
		$gvalue =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		
		$f{$gkey} = $gvalue;
		
		&logger($T,"io_get_query",$gkey,$gvalue);
	
	}
}

# get a parameter from header or query string
# [0] param
# return param value
# or undef on not found
sub io_get_param {
	
	&logger($T,"io_get_param",$_[0]);
	
	# get the from header
	my $f_parm = $ENV{"HTTP_PICO_STREAMER_" . uc($_[0])}; 
	
	# otherwise from query string
	if($f_parm eq "") {
		
		&logger($T,"io_get_param","f",$f{$_[0]});
		return $f{$_[0]};
	
	} else {
		
		&logger($T,"io_get_param","HTTP_PICO_STREAMER_" . uc($_[0]),$f_parm);	
		return $f_parm;
	}
}

# print data and exit
# [0] message ([1] content-type)
sub io_printout {
	
	&logger($T,"io_printout");
	
	my $cotype = "text/html";
	
	if($_[1] ne "") {
	
		$cotype = $_[1];
	}
	
	print "Content-Type: " . $cotype . "\n\n";
	print  $_[0] . "\n";
	exit;
}

# print exit status and exit
# [0] errocode ([1] extended error)
sub io_err {

	&logger($T,"io_err",$_[0]);
	
	my $ec = $_[0];
	my $es = $c_errcode{$ec};
	
	if(!defined($es)) {
		
		$es = "UnknownError";
		$ec = "999";
	}
	
	my $exe = $_[1];
	
	if($exe ne "") {
		
		$exe .= "\n";
	}
	
	print "Content-Type: text/html\n\n" . $ec . " " . $es . "\n" . $exe;
	exit;
}

# get user and password from http headers
# or from GET params
sub io_get_user {

	&logger($T,"io_get_user");
	
	# get user and pass from header
	($f_user, $f_pass) = split(/:/,$ENV{"HTTP_PICO_STREAMER_ID"}); 

	# otherwise from GET
	if($f_user eq "") {
	
		$f_user = $f{'user'};
		$f_pass = $f{'pass'};
		
	}
}

1;