/*
 * Decompiled with CFR 0.152.
 */
public class PicoIcy {
    private static int VER_MAX = 1;
    private static int VER_MIN = 3;

    public static void main(String[] stringArray) {
        System.out.print("\n\tPicoIcy " + VER_MAX + "." + VER_MIN + " 2004 by Vinz486.com\n\n");
        System.out.print("ShoutCast to PicoStreamer source protocol wrapper.\n\n");
        String string = "default.cfg";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        Logger.log("Loading cfg file ...", false);
        try {
            new Config(string, VER_MAX + "." + VER_MIN);
        }
        catch (Exception exception) {
            Logger.log("Error on loading configuration file: " + exception.toString());
            System.exit(1);
        }
        Logger.ok();
        if (!Config.protocol.equalsIgnoreCase("shoutcast") && !Config.protocol.equalsIgnoreCase("icecast")) {
            Logger.log("Invalid protocol specified in config file: " + Config.protocol);
            Logger.log("Must be SHOUTCAST or ICECAST.");
            System.exit(3);
        }
        String string2 = "";
        if (Config.useproxy) {
            string2 = " via proxy " + Config.proxy + ":" + Config.proxyport;
        }
        Logger.log("\nUser " + Config.user + " at " + Config.host + ":" + Config.port + string2 + "\n");
        try {
            if (Config.protocol.equalsIgnoreCase("shoutcast")) {
                Logger.log("Starting ShoutCast server ...", false);
                new ShoutListener();
            } else {
                Logger.log("Starting IceCast server ...", false);
                new IceListener();
            }
        }
        catch (Exception exception) {
            Logger.log("\nFatal error: " + Config.err);
        }
    }
}

