/*
 * Decompiled with CFR 0.152.
 */
public final class Base64 {
    private static final char[] BASE64CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char PAD = '=';
    private static final String CRLF = "\r\n";

    private Base64() {
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; i += 3) {
            int n = 0;
            if (i % 54 == 0 && i != 0) {
                stringBuffer.append(CRLF);
            }
            if (byArray.length <= i + 1) {
                n = Base64.eightbit(byArray[i]) << 16;
                stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 18)]);
                stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 12)]);
                stringBuffer.append('=');
                stringBuffer.append('=');
                continue;
            }
            if (byArray.length <= i + 2) {
                n = Base64.eightbit(byArray[i]) << 16 | Base64.eightbit(byArray[i + 1]) << 8;
                stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 18)]);
                stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 12)]);
                stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 6)]);
                stringBuffer.append('=');
                continue;
            }
            n = Base64.eightbit(byArray[i]) << 16 | Base64.eightbit(byArray[i + 1]) << 8 | Base64.eightbit(byArray[i + 2]);
            stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 18)]);
            stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 12)]);
            stringBuffer.append(BASE64CHARS[Base64.sixbit(n >> 6)]);
            stringBuffer.append(BASE64CHARS[Base64.sixbit(n)]);
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = string.getBytes();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (n3 < 4) {
                n = Base64.decodeInt(byArray[i]);
                if (n == -1) continue;
                if (n == -2 && n3 != 2 && n3 != 3) {
                    return null;
                }
                if (n == -2 && n3 == 2) {
                    stringBuffer.append((char)Base64.eightbit(n2 >> 4));
                    return stringBuffer.toString();
                }
                if (n == -2 && n3 == 3) {
                    stringBuffer.append((char)Base64.eightbit(n2 >> 10));
                    stringBuffer.append((char)Base64.eightbit(n2 >> 2));
                    return stringBuffer.toString();
                }
                n2 = n2 << 6 | Base64.sixbit(n);
                ++n3;
            }
            if (n3 != 4) continue;
            stringBuffer.append((char)Base64.eightbit(n2 >> 16));
            stringBuffer.append((char)Base64.eightbit(n2 >> 8));
            stringBuffer.append((char)Base64.eightbit(n2));
            n2 = 0;
            n3 = 0;
        }
        return stringBuffer.toString();
    }

    private static int decodeInt(int n) {
        if (n >= 65 && n <= 90) {
            return n - 65;
        }
        if (n >= 97 && n <= 122) {
            return n - 97 + 26;
        }
        if (n >= 48 && n <= 57) {
            return n - 48 + 52;
        }
        if (n == 43) {
            return 62;
        }
        if (n == 47) {
            return 63;
        }
        if (n == 61) {
            return -2;
        }
        return -1;
    }

    private static int sixbit(int n) {
        return n & 0x3F;
    }

    private static int eightbit(int n) {
        return n & 0xFF;
    }
}

