/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;

public class ShoutListener
implements Wrapper {
    private InputStream sis;
    private OutputStream sos;
    public Socket source;
    public Socket stats;
    private PicoServer pico;
    private long dataout = 0L;
    private long prevdata = 0L;
    public boolean active = false;

    public ShoutListener() throws Exception {
        Logger.ok();
        Logger.log("Listening source on " + Config.bind + ":" + (Config.listen + 1) + " ...", false);
        ServerSocket serverSocket = Config.bind.equals("*") ? new ServerSocket(Config.listen + 1) : new ServerSocket(Config.listen + 1, 5, InetAddress.getByName(Config.bind));
        Logger.ok();
        Logger.log("Listening statistics on " + Config.bind + ":" + Config.listen + " ...", false);
        ServerSocket serverSocket2 = Config.bind.equals("*") ? new ServerSocket(Config.listen) : new ServerSocket(Config.listen, 5, InetAddress.getByName(Config.bind));
        Logger.ok();
        Logger.log("Starting stats thread ...", false);
        ShoutStats shoutStats = new ShoutStats(serverSocket2);
        Logger.ok();
        Logger.log("");
        block6: while (true) {
            try {
                while (true) {
                    int n;
                    String string;
                    String string2;
                    Logger.log("Waiting source ...", false);
                    this.source = serverSocket.accept();
                    this.source.setSoTimeout(20000);
                    this.sis = this.source.getInputStream();
                    this.sos = this.source.getOutputStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.sis));
                    Logger.log(" connected: " + this.source.getInetAddress().getCanonicalHostName() + " [" + this.source.getRemoteSocketAddress().toString() + "]");
                    Logger.log("Checking password ...", false);
                    Config.pass = string2 = bufferedReader.readLine();
                    this.pico = new PicoServer();
                    String string3 = this.pico.getData("auth");
                    if (!string3.startsWith("200")) {
                        Logger.log("bad password or data: " + Config.err);
                        this.sos.write("KO\r\n".getBytes());
                        this.source.close();
                        continue;
                    }
                    Logger.ok();
                    this.sos.write("OK2\r\n".getBytes());
                    this.sos.write("icy-caps:11\r\n\r\n".getBytes());
                    if (Config.useproxy) {
                        string = Config.proxy;
                        n = Config.proxyport;
                    } else {
                        string = Config.host;
                        n = Config.port;
                    }
                    this.getShout(bufferedReader);
                    Logger.log("Connecting to PicoStreamer server ...", false);
                    Socket socket = new Socket(string, n);
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(this.pico.getHeaders("source").getBytes());
                    Logger.ok();
                    Logger.log("");
                    this.active = true;
                    this.dataout = 0L;
                    this.prevdata = 0L;
                    new Connector(this.sis, outputStream, this);
                    while (this.active) {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    try {
                        this.source.close();
                        shoutStats.alt();
                        continue block6;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                Logger.log("\nSource connection closed:" + PicoServer.err(exception) + "\n");
                try {
                    this.source.close();
                }
                catch (Exception exception2) {
                }
                continue;
            }
            break;
        }
    }

    private void getShout(BufferedReader bufferedReader) throws Exception {
        boolean bl = true;
        Properties properties = new Properties();
        while (bl) {
            String string = bufferedReader.readLine();
            if (string.equals("")) {
                bl = false;
                continue;
            }
            int n = string.indexOf(":");
            String string2 = string.substring(n + 1).trim();
            String string3 = string.substring(0, n).trim();
            properties.setProperty(string3.toLowerCase(), string2);
        }
        Config.info = properties.getProperty("icy-name", "unknown");
        Config.bits = properties.getProperty("icy-br", "N/A");
        Config.ctype = properties.getProperty("content-type", "audio/mpeg");
    }

    public void alt() {
        Logger.log("\nSource connection closed: " + Config.err + "\n");
        this.active = false;
    }

    public void data(int n) {
        this.dataout += (long)n;
        if (this.dataout / 1024L != this.prevdata) {
            Logger.line(this.dataout / 1024L + " kbytes sent");
        }
        this.prevdata = this.dataout;
    }
}

